<?php
// Model JadwalShift
namespace App\Models;

use App\Models\Shift;
use App\Models\Departemen;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class JadwalShift extends Model
{
    use HasFactory;

    protected $table = 'jadwal_shift';

    protected $fillable = [
        'departemen_id',
        'shift_id',
        'tanggal_mulai',
        'tanggal_selesai',
        'is_active'
    ];

    protected $casts = [
        'tanggal_mulai' => 'date',
        'tanggal_selesai' => 'date',
        'is_active' => 'boolean',
    ];

    public function departemen()
    {
        return $this->belongsTo(Departemen::class);
    }

    public function shift()
    {
        return $this->belongsTo(Shift::class);
    }
}
